
using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.BO
{
    public class Class : PI.FM.N000.Base.BL.BO.Base
    {
        public Class(Gemini.Core.BL.Interface.DBD.IDBDBase DBDBase)
            : base(DBDBase) { }

        #region Public members

        public long? SchoolID
        {
            get { return GetValue<long?>("SchoolID"); }
            set { SetValue<long?>("SchoolID", value); }
        }

        public long? SchoolYearID
        {
            get { return GetValue<long?>("SchoolYearID"); }
            set { SetValue<long?>("SchoolYearID", value); }
        }
        
        public long? InstructorID
        {
            get { return GetValue<long?>("InstructorID"); }
            set { SetValue<long?>("InstructorID", value); }
        }
        
        public string Name
        {
            get { return GetValue<string>("Name"); }
            set { SetValue<string>("Name", value); }
        }
        #endregion

        public override string DisplayValue
        {
            get
            {
                return Name;
            }
        }

        /// <summary>
        /// Zwraca klase 
        /// </summary>
        /// <returns></returns>
        internal BL.API.Model.GClass GetApiObject()
        {
            return new API.Model.GClass() { id = ID.ToString(), name = Name, teacher_id = InstructorID.HasValue ? InstructorID.ToString() : string.Empty, school_id = SchoolID.HasValue ? SchoolID.ToString() : string.Empty };
        }

        internal void Assign(API.Model.GClass Class)
        {
            ID = long.Parse(Class.id);
            Name = Class.name;
            InstructorID = string.IsNullOrEmpty(Class.teacher_id) ? null : (long?)long.Parse(Class.teacher_id); // to jest UserBID - trzeba potem to przekonwertowac na InstruktorID
            SchoolID = string.IsNullOrEmpty(Class.school_id) ? null : (long?)long.Parse(Class.school_id);
        }

        #region Search
        public new class Search : PI.FM.N000.Base.BL.BO.Base.Search
        {
            public long?    SchoolID        { get; set; }
            public long?    SchoolYearID    { get; set; }
            public long?    InstructorID    { get; set; }
            public string   Name            { get; set; }
        }
        #endregion
    }
}
